<?php
// ============================================
// CONFIGURATION - À MODIFIER AVANT DÉPLOIEMENT
// ============================================

// Identifiants Admin (CHANGEZ CES VALEURS !)
define('ADMIN_USERNAME', 'admin');
define('ADMIN_PASSWORD', 'ChangezCeMotDePasse123!');  // Minimum 8 caractères

// Clé secrète pour les sessions (générez une chaîne aléatoire)
define('SECRET_KEY', 'changez-cette-cle-secrete-avec-quelque-chose-de-random');

// Configuration API IA
define('AI_PROVIDER', 'gemini');  // Options: 'gemini', 'openai', 'claude'
define('GEMINI_API_KEY', 'VOTRE_CLE_GEMINI_ICI');
define('OPENAI_API_KEY', '');
define('CLAUDE_API_KEY', '');

// Chemins (ne pas modifier sauf si nécessaire)
define('DATA_DIR', __DIR__ . '/data/');

// ============================================
// NE PAS MODIFIER CI-DESSOUS
// ============================================

// Créer le dossier data s'il n'existe pas
if (!file_exists(DATA_DIR)) {
    mkdir(DATA_DIR, 0755, true);
}

// Fichiers de données
define('ACCOUNTS_FILE', DATA_DIR . 'accounts.json');
define('STATEMENTS_FILE', DATA_DIR . 'statements.json');

// Initialiser les fichiers s'ils n'existent pas
if (!file_exists(ACCOUNTS_FILE)) {
    file_put_contents(ACCOUNTS_FILE, json_encode([]));
}
if (!file_exists(STATEMENTS_FILE)) {
    file_put_contents(STATEMENTS_FILE, json_encode([]));
}

// Démarrer la session
session_start();

// Fonction pour vérifier l'authentification
function isAuthenticated() {
    return isset($_SESSION['authenticated']) && $_SESSION['authenticated'] === true;
}

// Fonction pour vérifier le login
function checkLogin($username, $password) {
    return $username === ADMIN_USERNAME && $password === ADMIN_PASSWORD;
}

// Headers CORS et JSON pour l'API
function setApiHeaders() {
    header('Content-Type: application/json');
    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: GET, POST, DELETE, OPTIONS');
    header('Access-Control-Allow-Headers: Content-Type');
}

// Réponse JSON
function jsonResponse($data, $code = 200) {
    http_response_code($code);
    echo json_encode($data);
    exit;
}

// Vérifier l'authentification pour l'API
function requireAuth() {
    if (!isAuthenticated()) {
        jsonResponse(['error' => 'Non autorisé'], 401);
    }
}
