<?php
require_once __DIR__ . '/../config.php';
setApiHeaders();

// Handle preflight
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

// Vérifier l'authentification
requireAuth();

$method = $_SERVER['REQUEST_METHOD'];
$input = json_decode(file_get_contents('php://input'), true);

// Charger les relevés
function getStatements() {
    $data = file_get_contents(STATEMENTS_FILE);
    return json_decode($data, true) ?: [];
}

// Sauvegarder les relevés
function saveStatements($statements) {
    file_put_contents(STATEMENTS_FILE, json_encode($statements, JSON_PRETTY_PRINT));
}

switch ($method) {
    case 'GET':
        // Liste des relevés
        $accountId = $_GET['accountId'] ?? null;
        $statements = getStatements();
        
        if ($accountId) {
            $statements = array_filter($statements, fn($s) => $s['accountId'] === $accountId);
        }
        
        jsonResponse(array_values($statements));
        break;
        
    case 'POST':
        // Créer un relevé
        $accountId = $input['accountId'] ?? '';
        $fileName = $input['fileName'] ?? '';
        $analysis = $input['analysis'] ?? null;
        
        if (empty($accountId) || empty($analysis)) {
            jsonResponse(['error' => 'Données manquantes'], 400);
        }
        
        $statements = getStatements();
        $newStatement = [
            'id' => uniqid(),
            'accountId' => $accountId,
            'fileName' => $fileName,
            'analyzedAt' => date('c'),
            'analysis' => $analysis
        ];
        
        $statements[] = $newStatement;
        saveStatements($statements);
        
        jsonResponse($newStatement, 201);
        break;
        
    case 'DELETE':
        // Supprimer un relevé
        $id = $input['id'] ?? $_GET['id'] ?? '';
        
        if (empty($id)) {
            jsonResponse(['error' => 'ID du relevé requis'], 400);
        }
        
        $statements = getStatements();
        $statements = array_filter($statements, fn($s) => $s['id'] !== $id);
        saveStatements(array_values($statements));
        
        jsonResponse(['success' => true]);
        break;
        
    default:
        jsonResponse(['error' => 'Méthode non autorisée'], 405);
}
