<?php
require_once __DIR__ . '/../config.php';
setApiHeaders();

// Handle preflight
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

$input = json_decode(file_get_contents('php://input'), true);
$action = $input['action'] ?? $_GET['action'] ?? '';

switch ($action) {
    case 'login':
        $username = $input['username'] ?? '';
        $password = $input['password'] ?? '';
        
        if (checkLogin($username, $password)) {
            $_SESSION['authenticated'] = true;
            $_SESSION['login_time'] = time();
            jsonResponse(['success' => true, 'message' => 'Connexion réussie']);
        } else {
            jsonResponse(['success' => false, 'message' => 'Identifiants incorrects'], 401);
        }
        break;
        
    case 'logout':
        session_destroy();
        jsonResponse(['success' => true, 'message' => 'Déconnexion réussie']);
        break;
        
    case 'check':
        jsonResponse([
            'authenticated' => isAuthenticated(),
            'session_time' => isset($_SESSION['login_time']) ? time() - $_SESSION['login_time'] : 0
        ]);
        break;
        
    default:
        jsonResponse(['error' => 'Action non reconnue'], 400);
}
