<?php
require_once __DIR__ . '/../config.php';
setApiHeaders();

// Handle preflight
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

// Vérifier l'authentification
requireAuth();

$method = $_SERVER['REQUEST_METHOD'];
$input = json_decode(file_get_contents('php://input'), true);

// Charger les comptes
function getAccounts() {
    $data = file_get_contents(ACCOUNTS_FILE);
    return json_decode($data, true) ?: [];
}

// Sauvegarder les comptes
function saveAccounts($accounts) {
    file_put_contents(ACCOUNTS_FILE, json_encode($accounts, JSON_PRETTY_PRINT));
}

switch ($method) {
    case 'GET':
        // Liste des comptes
        jsonResponse(getAccounts());
        break;
        
    case 'POST':
        // Créer un compte
        $name = trim($input['name'] ?? '');
        
        if (empty($name)) {
            jsonResponse(['error' => 'Nom du compte requis'], 400);
        }
        
        $accounts = getAccounts();
        $newAccount = [
            'id' => uniqid(),
            'name' => $name,
            'createdAt' => date('c')
        ];
        
        $accounts[] = $newAccount;
        saveAccounts($accounts);
        
        jsonResponse($newAccount, 201);
        break;
        
    case 'DELETE':
        // Supprimer un compte
        $id = $input['id'] ?? $_GET['id'] ?? '';
        
        if (empty($id)) {
            jsonResponse(['error' => 'ID du compte requis'], 400);
        }
        
        $accounts = getAccounts();
        $accounts = array_filter($accounts, fn($a) => $a['id'] !== $id);
        saveAccounts(array_values($accounts));
        
        // Supprimer aussi les relevés associés
        $statements = json_decode(file_get_contents(STATEMENTS_FILE), true) ?: [];
        $statements = array_filter($statements, fn($s) => $s['accountId'] !== $id);
        file_put_contents(STATEMENTS_FILE, json_encode(array_values($statements), JSON_PRETTY_PRINT));
        
        jsonResponse(['success' => true]);
        break;
        
    default:
        jsonResponse(['error' => 'Méthode non autorisée'], 405);
}
